/*
 * Decompiled with CFR 0.152.
 */
package info.sigmaclient.jelloprelauncher.ressources;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import info.sigmaclient.jelloprelauncher.DownloadProgress;
import info.sigmaclient.jelloprelauncher.Utils;
import info.sigmaclient.jelloprelauncher.ressources.type.Asset;
import info.sigmaclient.jelloprelauncher.ressources.type.Client;
import info.sigmaclient.jelloprelauncher.ressources.type.Library;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RessourceManager {
    private final List<Library> libraries = new ArrayList<Library>();
    private final List<Asset> assets = new ArrayList<Asset>();
    private final JsonObject versionJson;
    private JsonObject assetsJson;
    private final Client client;

    public RessourceManager(File jsonFile) throws IOException {
        try (Scanner scanner = new Scanner(jsonFile);){
            String text = scanner.useDelimiter("\\A").next();
            this.versionJson = Json.parse(text).asObject();
            this.parseLibraries();
            String versionName = this.versionJson.getString("id", null);
            String versionAssets = this.versionJson.getString("assets", null);
            this.client = new Client(null, null, 0, versionName, versionAssets);
        }
    }

    public RessourceManager(String jsonUrl) {
        this.versionJson = Utils.queryJson(jsonUrl);
        String versionName = this.versionJson.getString("id", null);
        String versionAssets = this.versionJson.getString("assets", null);
        JsonObject assetIndex = this.versionJson.get("assetIndex").asObject();
        String assetsUrl = assetIndex.getString("url", null);
        this.assetsJson = Utils.queryJson(assetsUrl);
        JsonObject downloads = this.versionJson.get("downloads").asObject().get("client").asObject();
        String clientSha1 = downloads.getString("sha1", null);
        String clientUrl = downloads.getString("url", null);
        int clientSize = downloads.getInt("size", 0);
        this.client = new Client(clientUrl, clientSha1, clientSize, versionName, versionAssets);
        this.parseAssets();
        this.parseLibraries();
    }

    private void parseAssets() {
        JsonObject assetObjects = this.assetsJson.get("objects").asObject();
        for (String name : assetObjects.names()) {
            JsonObject asset = assetObjects.get(name).asObject();
            this.assets.add(new Asset(name, asset.getString("hash", null), asset.getInt("size", 0)));
        }
    }

    private void parseLibraries() {
        String osName = Utils.getPlatformName();
        String arch = System.getProperty("sun.arch.data.model");
        JsonArray librariesArray = this.versionJson.get("libraries").asArray();
        for (JsonValue value : librariesArray) {
            JsonObject downloads;
            String path;
            JsonObject libraryJson = value.asObject();
            if (!this.isAllowedByRules(libraryJson, osName) || (path = (downloads = libraryJson.get("downloads").asObject().get("artifact").asObject()).getString("path", null)).contains("realms")) continue;
            this.libraries.add(new Library(path, downloads.getString("sha1", null), downloads.getInt("size", 0), downloads.getString("url", null)));
            if (libraryJson.get("natives") == null) continue;
            this.handleNatives(libraryJson, osName, arch);
        }
    }

    private void handleNatives(JsonObject libraryJson, String osName, String arch) {
        JsonObject natives = libraryJson.get("natives").asObject();
        String nativeName = natives.getString(osName, natives.getString(osName + arch, null));
        if (nativeName != null) {
            JsonObject classifiers = libraryJson.get("downloads").asObject().get("classifiers").asObject();
            JsonObject nativeJson = classifiers.get(nativeName).asObject();
            String path = nativeJson.getString("path", null);
            if (nativeJson.getString("url", null).endsWith(".zip")) {
                path = path + "natives.zip";
            }
            this.libraries.add(new Library(path, nativeJson.getString("sha1", null), nativeJson.getInt("size", 0), nativeJson.getString("url", null)));
        }
    }

    private boolean isAllowedByRules(JsonObject libraryJson, String osName) {
        if (libraryJson.get("rules") == null) {
            return true;
        }
        boolean allowed = false;
        for (JsonValue ruleVal : libraryJson.get("rules").asArray()) {
            JsonObject os;
            JsonObject rule = ruleVal.asObject();
            JsonObject jsonObject = os = rule.get("os") != null ? rule.get("os").asObject() : null;
            if (os != null && !osName.equals(os.getString("name", null))) continue;
            allowed = "allow".equals(rule.getString("action", null));
        }
        return allowed;
    }

    public void download(DownloadProgress progress) throws IOException {
        int totalSize = this.calculateTotalDownloadSize();
        System.out.println("Size to download: " + totalSize + "B");
        int downloadedSize = 0;
        for (Asset asset : this.assets) {
            downloadedSize += this.downloadAsset(asset, progress, totalSize, downloadedSize);
        }
        for (Library library : this.libraries) {
            downloadedSize += this.downloadLibrary(library, progress, totalSize, downloadedSize);
        }
        downloadedSize += this.downloadClient(progress, totalSize, downloadedSize);
        this.saveJsonFiles();
    }

    private int calculateTotalDownloadSize() {
        return this.assets.stream().mapToInt(Asset::getSize).sum() + this.libraries.stream().mapToInt(Library::getSize).sum() + this.client.getSize();
    }

    private int downloadAsset(Asset asset, DownloadProgress progress, int totalSize, int downloadedSize) {
        File destination = new File(Utils.getWorkingDirectory(), "assets" + File.separator + "objects" + File.separator + asset.getHash().substring(0, 2) + File.separator + asset.getHash());
        if (!destination.exists()) {
            Utils.downloadFileFromUrl("https://resources.download.minecraft.net/" + asset.getHash().substring(0, 2) + "/" + asset.getHash(), destination, null);
            progress.update(downloadedSize, totalSize);
            return asset.getSize();
        }
        return 0;
    }

    private int downloadLibrary(Library library, DownloadProgress progress, int totalSize, int downloadedSize) throws IOException {
        File destination = new File(Utils.getWorkingDirectory(), "libraries" + File.separator + library.getPath().replace("//", File.separator));
        String sha1 = library.getHash();
        String sha2 = Utils.getFileSha1Sum(destination);
        if (!destination.exists() || !Objects.equals(sha2, sha1)) {
            Utils.downloadFileFromUrl(library.getUrl(), destination, null);
            System.out.println(library.getUrl() + " - " + library.getHash());
            progress.update(downloadedSize, totalSize);
            this.extractLibraryIfNeeded(library, destination);
            return library.getSize();
        }
        return 0;
    }

    private void extractLibraryIfNeeded(Library library, File destination) throws IOException {
        if (library.getUrl().endsWith(".zip")) {
            try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(destination.toPath(), new OpenOption[0]));){
                ZipEntry ze;
                byte[] buffer = new byte[4096];
                while ((ze = zis.getNextEntry()) != null) {
                    File destFile = new File(destination.getParent(), ze.getName());
                    if (ze.isDirectory()) {
                        destFile.mkdirs();
                        continue;
                    }
                    FileOutputStream fos = new FileOutputStream(destFile);
                    Throwable throwable = null;
                    try {
                        int read;
                        while ((read = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
            }
        }
    }

    private int downloadClient(DownloadProgress progress, int totalSize, int downloadedSize) {
        File clientPath = this.getClientPath();
        String sha1 = this.client.getHash();
        String sha2 = Utils.getFileSha1Sum(clientPath);
        if (!clientPath.exists() || !Objects.equals(sha2, sha1)) {
            Utils.downloadFileFromUrl(this.client.getUrl(), clientPath, (size, total) -> progress.update((long)downloadedSize + size, totalSize));
            return this.client.getSize();
        }
        return 0;
    }

    private void saveJsonFiles() throws IOException {
        Files.write(this.getClientJsonPath().toPath(), this.versionJson.toString().getBytes(), new OpenOption[0]);
        Files.write(this.getAssetsJsonPath().toPath(), this.assetsJson.toString().getBytes(), new OpenOption[0]);
    }

    public File getClientPath() {
        return new File(this.client.getClientWorkingDir(), this.client.getName() + ".jar");
    }

    public File getClientJsonPath() {
        return new File(this.client.getClientWorkingDir(), this.client.getName() + ".json");
    }

    public File getAssetsJsonPath() {
        return new File(Utils.getWorkingDirectory(), "assets" + File.separator + "indexes" + File.separator + this.client.getAssetsVersion() + ".json");
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public Client getClient() {
        return this.client;
    }
}

