/*
 * Decompiled with CFR 0.152.
 */
package info.sigmaclient.jelloprelauncher.gui;

import info.sigmaclient.jelloprelauncher.JelloPrelauncher;
import info.sigmaclient.jelloprelauncher.Utils;
import info.sigmaclient.jelloprelauncher.gui.ImagePanel;
import info.sigmaclient.jelloprelauncher.gui.JelloButton;
import info.sigmaclient.jelloprelauncher.gui.JelloProgressBar;
import info.sigmaclient.jelloprelauncher.versions.Version;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DownloadFrame
extends JFrame
implements ActionListener {
    private final JProgressBar jProgressBar = new JProgressBar();
    private final JelloButton play = new JelloButton("Play!");
    private final JLabel label = new JLabel();
    public final JComboBox<String> comboBox;
    Thread autoPlay;

    public DownloadFrame() throws HeadlessException {
        this.setTitle("Sigma Jello Bootstrap");
        this.setResizable(false);
        this.setSize(580, 150);
        this.setLocationRelativeTo(null);
        this.setBackground(Color.BLACK);
        this.jProgressBar.setUI(new JelloProgressBar());
        this.jProgressBar.setBounds(26, 80, this.getWidth() - 50, 25);
        this.jProgressBar.setBorderPainted(false);
        this.jProgressBar.setBorder(null);
        this.jProgressBar.setVisible(false);
        ImagePanel image = new ImagePanel();
        try {
            image.setImage(ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResource("logo.png"))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        image.setBounds(26, 28, 221, 35);
        this.label.setText("Auto Play in 10s..");
        this.label.setBounds(this.getWidth() - 228, 44, 200, 20);
        this.label.setHorizontalAlignment(4);
        this.label.setForeground(Color.WHITE);
        this.autoPlay = new Thread(() -> {
            for (int i = 0; i < 10; ++i) {
                this.label.setText("Auto Play in " + (10 - i) + "s..");
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var3) {
                    return;
                }
                if (!Thread.interrupted()) continue;
                return;
            }
            SwingUtilities.invokeLater(() -> JelloPrelauncher.shared.play());
        });
        this.play.setBounds(360, 75, 195, 30);
        this.play.setVisible(true);
        this.play.setText("Play!");
        this.play.addActionListener(action -> SwingUtilities.invokeLater(() -> {
            this.autoPlay.interrupt();
            JelloPrelauncher.shared.play();
        }));
        this.comboBox = new JComboBox();
        this.comboBox.setBounds(26, 80, 195, 22);
        this.comboBox.addActionListener(this);
        this.play.setEnabled(false);
        JPanel pane = new JPanel();
        pane.add(this.label);
        pane.add(image);
        pane.add(this.jProgressBar);
        pane.add(this.play);
        pane.add(this.comboBox);
        pane.setBackground(Color.BLACK);
        pane.setLayout(null);
        this.add(pane);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = (String)this.comboBox.getSelectedItem();
        if (JelloPrelauncher.shared != null) {
            JelloPrelauncher.shared.setVersion(s);
        }
        if (this.autoPlay != null) {
            this.autoPlay.interrupt();
            this.label.setText("Select version and play!");
        }
    }

    public void setVersions(HashMap<String, Version> hashMap) {
        this.play.setEnabled(true);
        ArrayList<String> versions = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : hashMap.entrySet()) {
            versions.add(entry.getValue().getDisplayName());
        }
        versions.sort((a, b) -> {
            boolean aIsNumeric = Character.isDigit(a.charAt(0));
            boolean bIsNumeric = Character.isDigit(b.charAt(0));
            if (aIsNumeric && !bIsNumeric) {
                return 1;
            }
            if (!aIsNumeric && bIsNumeric) {
                return -1;
            }
            return a.compareToIgnoreCase((String)b);
        });
        for (String version : versions) {
            this.comboBox.addItem(version);
            if (!version.contains("Nightly")) continue;
            this.comboBox.setSelectedItem(Utils.isPojav() ? "1.21.5 - 1.7.10 (Pojav-Nightly)" : "1.21.5 - 1.7.10 (Nightly)");
        }
        if (this.autoPlay == null || !this.autoPlay.isAlive()) {
            this.autoPlay = new Thread(() -> {
                for (int i = 0; i < 10; ++i) {
                    this.label.setText("Auto Play in " + (10 - i) + "s..");
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                    if (!Thread.interrupted()) continue;
                    return;
                }
                SwingUtilities.invokeLater(() -> JelloPrelauncher.shared.play());
            });
            this.autoPlay.start();
        }
    }

    public void setProgress(int progress, String name) {
        this.play.setVisible(false);
        this.comboBox.setVisible(false);
        this.jProgressBar.setVisible(true);
        this.jProgressBar.setValue(Math.min(100, progress));
        this.label.setText(name + " " + progress + "%");
        this.repaint();
    }
}

