/*
 * Decompiled with CFR 0.152.
 */
package info.sigmaclient.jelloprelauncher;

import info.sigmaclient.jelloprelauncher.Utils;
import info.sigmaclient.jelloprelauncher.gui.DownloadFrame;
import info.sigmaclient.jelloprelauncher.ressources.RessourceManager;
import info.sigmaclient.jelloprelauncher.ressources.type.Library;
import info.sigmaclient.jelloprelauncher.versions.Version;
import info.sigmaclient.jelloprelauncher.versions.VersionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;

public class JelloPrelauncher {
    public static JelloPrelauncher shared;
    DownloadFrame df;
    private static String[] launchArgs;
    private static File sigmaDir;
    private static File jreDir;
    private Version toLaunch;
    private VersionManager versionManager;

    public static void main(String[] args) {
        shared = new JelloPrelauncher(args);
    }

    public static RessourceManager getRessourceManager(Version version) throws IOException {
        System.out.println(version.getDisplayName());
        return version.isOffline() ? new RessourceManager(new File(version.getUrl())) : new RessourceManager(version.getUrl());
    }

    public JelloPrelauncher(String[] args) {
        if (!sigmaDir.exists()) {
            sigmaDir.mkdirs();
        }
        System.out.println("Starting...");
        new File(sigmaDir, "SigmaJello.jar");
        launchArgs = args;
        this.versionManager = new VersionManager("https://jelloprg.sigmaclient.cloud/version_manifest.json");
        this.setupWindow();
        this.df.setVersions(this.versionManager.getVersions());
        this.versionManager.getVersions().forEach((s, version) -> {
            String display = version.getDisplayName();
            if (display.contains("Nightly")) {
                if (Utils.isPojav() && display.contains("Pojav")) {
                    this.toLaunch = version;
                } else if (!Utils.isPojav() && !display.contains("Pojav")) {
                    this.toLaunch = version;
                }
            }
        });
    }

    public void setupRuntime() {
        String osName = System.getProperty("os.name");
        String platform = !osName.startsWith("Mac") && !osName.startsWith("Darwin") ? (osName.toLowerCase().contains("windows") ? "windows" : "linux") : "mac";
        String jre = "jre";
        if (this.toLaunch.getDisplayName().contains("Nightly")) {
            jre = "jre17";
            jreDir = new File(sigmaDir, "jre17.0.15");
        }
        if (!jreDir.exists()) {
            try {
                File temporaryJreFile = File.createTempFile("sigma", jre);
                Utils.downloadFileFromUrl("https://jelloprg.sigmaclient.cloud/download/" + platform + "/" + jre, temporaryJreFile, (totalDownloadedSize, totalFileSize) -> this.df.setProgress((int)(100L * totalDownloadedSize / totalFileSize), "Updating Runtime"));
                byte[] buffer = new byte[1024];
                ZipInputStream zis = new ZipInputStream(Files.newInputStream(temporaryJreFile.toPath(), new OpenOption[0]));
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File newFile = new File(sigmaDir, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        int len;
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
            for (File f : this.getFilesRecursive(jreDir)) {
                f.setExecutable(true);
            }
        }
    }

    private void setupWindow() {
        if (this.df == null) {
            SwingUtilities.invokeLater(() -> {
                this.df = new DownloadFrame();
            });
        }
        while (this.df == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException var2) {
                var2.printStackTrace();
            }
        }
    }

    private ArrayList<File> getFilesRecursive(File pFile) {
        ArrayList<File> f = new ArrayList<File>();
        for (File files : pFile.listFiles()) {
            if (files.isDirectory()) {
                f.addAll(this.getFilesRecursive(files));
                continue;
            }
            f.add(files);
        }
        return f;
    }

    public static void launchGame(RessourceManager manager, String jreBinLoc, boolean macos) {
        String mainClass = "net.minecraft.client.main.Main";
        String cpSeparator = System.getProperty("os.name").toLowerCase().contains("win") ? ";" : ":";
        StringBuilder classPathBuilder = new StringBuilder(manager.getClientPath().getAbsolutePath());
        for (Library lib : manager.getLibraries()) {
            classPathBuilder.append(cpSeparator).append(lib.getFilePath().getAbsolutePath());
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add(jreBinLoc);
        if (macos) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : inputArguments) {
            if (arg.contains("-agentlib")) continue;
            jvmArgs.add(arg);
        }
        jvmArgs.add("-cp");
        jvmArgs.add(classPathBuilder.toString());
        jvmArgs.add("net.minecraft.client.main.Main");
        if (launchArgs == null || launchArgs.length == 0) {
            String assets = new File(Utils.getWorkingDirectory(), "assets").getAbsolutePath();
            launchArgs = new String[]{"--version", "mcp", "--accessToken", "0", "--assetsDir", assets, "--assetIndex", manager.getClient().getAssetsVersion(), "--userProperties", "{}"};
        }
        jvmArgs.addAll(Arrays.asList(launchArgs));
        System.out.println("Launching game with arguments:");
        for (String arg : jvmArgs) {
            System.out.println(arg);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(jvmArgs);
            processBuilder.directory(Utils.getWorkingDirectory());
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            int exitCode = process.waitFor();
            System.out.println("Game process exited with code: " + exitCode);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        this.df.setProgress(0, "Launching Client");
        new Thread(() -> {
            String jreBinLoc;
            this.setupRuntime();
            RessourceManager ressourceManager = null;
            try {
                ressourceManager = JelloPrelauncher.getRessourceManager(this.toLaunch);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.toLaunch.isOffline()) {
                try {
                    ressourceManager.download((current, total) -> this.df.setProgress((int)(100L * current / total), "Updating Client"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.df.setVisible(false);
            boolean i2 = false;
            String osName = System.getProperty("os.name");
            if (!osName.startsWith("Mac") && !osName.startsWith("Darwin")) {
                jreBinLoc = osName.toLowerCase().contains("windows") ? jreDir.getAbsolutePath() + File.separator + "bin" + File.separator + "java.exe" : jreDir.getAbsolutePath() + File.separator + "bin" + File.separator + "java";
            } else {
                jreBinLoc = jreDir.getAbsolutePath() + File.separator + "Contents" + File.separator + "Home" + File.separator + "bin" + File.separator + "java";
                i2 = true;
            }
            JelloPrelauncher.launchGame(ressourceManager, jreBinLoc, i2);
            System.exit(0);
        }).start();
    }

    public void setVersion(String s) {
        for (Map.Entry<String, Version> entry : this.versionManager.getVersions().entrySet()) {
            if (!s.equals(entry.getValue().getDisplayName())) continue;
            this.toLaunch = entry.getValue();
        }
    }

    static {
        sigmaDir = Utils.getSigmaDirectory();
        jreDir = new File(sigmaDir, "jre1.8.0_202");
    }
}

